% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PA.EMOA.plotDistribution.R
\name{plotDistribution}
\alias{plotDistribution}
\title{Plot distribution of EMOA indicators.}
\usage{
plotDistribution(
  inds,
  plot.type = "boxplot",
  fill = "algorithm",
  facet.type = "grid",
  facet.args = list(),
  logscale = character()
)
}
\arguments{
\item{inds}{[\code{data.frame}]\cr
Data frame with columns \dQuote{algorithm}, \dQuote{prob}, \dQuote{repl} and
one additional column per EMOA indicator.}

\item{plot.type}{[\code{character(1)}]\cr
Either \dQuote{boxplot} (the default) for boxplots or \dQuote{violin} for
violin plots.}

\item{fill}{[\code{character(1)}]\cr
Variable used to fill boxplots.
Default is \dQuote{algorithm}.}

\item{facet.type}{[\code{character(1)}]\cr
Which faceting method to use? Pass \dQuote{wrap} for \code{\link[ggplot2]{facet_wrap}}
or \dQuote{grid} for \code{\link[ggplot2]{facet_grid}}.
Default is \dQuote{wrap}.}

\item{facet.args}{[\code{list}]\cr
Named list of arguments passed down to \code{\link[ggplot2]{facet_wrap}} or
\code{\link[ggplot2]{facet_grid}} respectively (depends on \code{facet.type}).
E.g., \code{nrow} to change layout.
Default is the empty list. In this case data is grouped by problem and indicator.}

\item{logscale}{[\code{character}]\cr
Vector of indicator names which should be log-transformed prior to
visualization.
Default is the empty character vector.}
}
\value{
[\code{\link[ggplot2]{ggplot}}]
}
\description{
Visualizes of empirical distributions of unary EMOA indicator
based on the results of \code{\link{computeIndicators}}.
}
\seealso{
Other EMOA performance assessment tools: 
\code{\link{approximateNadirPoint}()},
\code{\link{approximateRefPoints}()},
\code{\link{approximateRefSets}()},
\code{\link{computeDominanceRanking}()},
\code{\link{emoaIndEps}()},
\code{\link{makeEMOAIndicator}()},
\code{\link{niceCellFormater}()},
\code{\link{normalize}()},
\code{\link{plotFront}()},
\code{\link{plotScatter2d}()},
\code{\link{plotScatter3d}()},
\code{\link{toLatex}()}
}
\concept{EMOA performance assessment tools}
