#' @title    Data for Example 8.2 from Experimental Design and Analysis for Tree Improvement
#' @name     DataExam8.2
#' @docType  data
#' @keywords datasets
#' @description Exam8.2 presents the Diameter at breast height (Dbh) of 60 SeedLots
#'              under layout of row column design with 6 rows and 10 columns in 18
#'              countries and 59 provinces of 18 selected countries.
#' @usage    data(DataExam8.2)
#' @format A \code{data.frame} with 236 rows and 8 variables.
#' \describe{
#'        \item{\code{repl}}{There are 4 replication for the design}
#'        \item{\code{row}}{Experiment is conducted under 6 rows}\
#'        \item{\code{column}}{Experiment is conducted under 4 columns}
#'        \item{\code{clonenum}}{Clonenum}
#'        \item{\code{contcompf}}{Contcompf}
#'        \item{\code{standard}}{Standard}
#'        \item{\code{clone}}{Clone}
#'        \item{\code{dbh}}{dbhmean}
#'        \item{\code{dbhvar}}{dbhvariance}
#'        \item{\code{ht}}{htmean}
#'        \item{\code{htvar}}{htvariance}
#'        \item{\code{count}}{count}
#'        \item{\code{contcompv}}{Contcompv}
#'        }
#'
#' @author
#' \enumerate{
#'          \item  Muhammad Yaseen (\email{myaseen208@@gmail.com})
#'          \item  Sami Ullah (\email{samiullahuos@@gmail.com})
#'          }
#'
#' @references
#' \enumerate{
#'          \item E.R. Williams, C.E. Harwood and A.C. Matheson (2023). \emph{Experimental Design and Analysis for Tree Improvement}.
#'                CSIRO Publishing (\href{https://www.publish.csiro.au/book/3145/}{https://www.publish.csiro.au/book/3145/}).
#'              }
#'
#' @seealso
#'    \code{\link{Exam8.2}}
#'
#' @examples
#' data(DataExam8.2)
NULL
