% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filing_documents.R
\name{filing_documents}
\alias{filing_documents}
\alias{filing_documents.character}
\alias{filing_documents.xml_node}
\title{SEC Filing Documents}
\usage{
filing_documents(x)

\method{filing_documents}{character}(x)

\method{filing_documents}{xml_node}(x)
}
\arguments{
\item{x}{URL or xml_document for a SEC filing index page}
}
\value{
A dataframe with all the documents in the filing along with their
   meta info
}
\description{
If you know you're going to want all the details of a filing, including documents
funds and filers, look at `filing_details`
}
\details{
Information returned:
\itemize{
 \item seq
 \item description
 \item document
 \item href
 \item type
 \item size
}
}
\examples{
\donttest{
# Typically you'd get the URL from one of the search functions
x <- paste0("https://www.sec.gov/Archives/edgar/data/",
            "712515/000071251517000063/0000712515-17-000063-index.htm")
try(filing_documents(x))
}
}
