% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parse_submission.R
\name{parse_submission}
\alias{parse_submission}
\title{Parse Submission}
\usage{
parse_submission(x, include.binary = T, include.content = T)
}
\arguments{
\item{x}{- Input submission to parse. May be one of the following:
\describe{
  \item{URI}{URL to a SEC complete submission text file}
  \item{Text}{String with the full submission}
  \item{File path}{Path to local file containing the submission}
}}

\item{include.binary}{- Default TRUE, determines if the content of binary
documents is returned.}

\item{include.content}{- Default TRUE, determines if the content of
documents is returned.}
}
\value{
a dataframe with one row per document. For the metadata (TYPE,
  DESCRIPTION, FILENAME) it is important to note that these are provided by
  the filer and have little standardization or enforcement.
  \describe{
    \item{SEQUENCE}{Sequence number of the file}
    \item{TYPE}{The type of document, e.g. 10-K, EX-99, GRAPHIC}
    \item{DESCRIPTION}{The type of document, e.g. 10-K, EX-99, GRAPHIC}
    \item{FILENAME}{The document's filename}
    \item{TEXT}{The text representation of the document. For text-based
      documents (txt, html) this is the actual file contents. For binary
      files (graphics, pdfs) this contains the uuencoded contents.}
  }
}
\description{
Raw SEC filings are sent in a SGML file - this parses that master submission
into component documents, with content lines in list column 'TEXT'.
}
\details{
Most of the time the information you need along with the specific files
will be available by using \code{\link{filing_documents}}, but there are
scenarios where you may want to access the full contents of the master
submission -
  \describe{
    \item{Old Submissions}{Older submissions are not parsed into component
          documents by the SEC so access requires parsing the main filing}
    \item{Full Document List}{The SEC only provides what it considers the
          relevant documents, but filings often include many more ancillary
          files}
    \item{Efficient Downloading}{If you're fetching many documents from a
          filing over many filings, there can be efficiency gains from just
          downloading a single file.}
  }

\emph{NOTE: non-text documents are uuencoded and need a separate decoder to be
viewed.}
}
\examples{
\donttest{
try(
  parse_submission(paste0('https://www.sec.gov/Archives/edgar/data/',
                   '37996/000003799617000084/0000037996-17-000084.txt'))[ ,
                     c('SEQUENCE', 'TYPE', 'DESCRIPTION', 'FILENAME')]
  )
}
}
