% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bundle_path.R
\name{edge_bundle_path}
\alias{edge_bundle_path}
\title{Edge-Path Bundling}
\usage{
edge_bundle_path(g, xy, max_distortion = 2, weight_fac = 2, segments = 20)
}
\arguments{
\item{g}{an igraph object}

\item{xy}{coordinates of vertices}

\item{max_distortion}{maximum distortion}

\item{weight_fac}{edge weight factor}

\item{segments}{number of subdivisions of edges}
}
\value{
data.frame containing the bundled edges
}
\description{
Implements edge-path bundling.
}
\details{
This is a re-implementation of https://github.com/mwallinger-tu/edge-path-bundling

see \href{https://github.com/schochastics/edgebundle}{online} for plotting tips
}
\examples{
library(igraph)
g <- graph_from_edgelist(matrix(c(
    1, 2, 1, 6,
    1, 4, 2, 3, 3, 4, 4, 5, 5, 6
), ncol = 2, byrow = TRUE), FALSE)
xy <- cbind(c(0, 10, 25, 40, 50, 50), c(0, 15, 25, 15, 0, -10))
edge_bundle_path(g, xy)
}
\references{
Wallinger, M., Archambault, D., Auber, D., Nollenburg, M., & Peltonen, J. (2021). Edge-Path Bundling: A Less Ambiguous Edge Bundling Approach. IEEE Transactions on Visualization and Computer Graphics.
}
\seealso{
\link{edge_bundle_hammer},\link{edge_bundle_stub},\link{edge_bundle_force}
}
\author{
David Schoch
}
