% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rxc.R
\docType{data}
\name{rxc_hier}
\alias{rxc_hier}
\title{Rx Condition Hierarchies - Table 11}
\format{
An object of class \code{tbl_df} (inherits from \code{tbl}, \code{data.frame}) with
1 rows and 3 columns
\describe{
\item{rxc}{Rx condition code without leading zeroes}
\item{desc}{Rx condition code description}
\item{set_0}{Rx condition code that falls below \code{rxc} on the hierarchy
No leading zeroes}
}
}
\source{
Data import and cleaning at:
\url{https://github.com/EeethB/edgedata/tree/main/data-raw}
}
\usage{
rxc_hier
}
\description{
A dataset used to apply the risk adjustment Rx condition category
hierarchies. The HHS risk model uses \emph{hierarchical} condition categories.
This means that when an individual has e.g. RXC 6 (Insulin), they do not also
get the risk score for RXC 7 (Anti-Diabetic Agents, Except Insulin...).
}
\seealso{
Other RXC tables: 
\code{\link{adult_rxc_hcc_inter}},
\code{\link{adult_rxc}},
\code{\link{hcpcs_rxc}},
\code{\link{ndc_rxc}}
}
\concept{RXC tables}
\keyword{datasets}
