% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assess_performance.R
\name{beta_bias}
\alias{beta_bias}
\title{Percent Bias of Estimated Coefficient}
\usage{
beta_bias(df, true_rr)
}
\arguments{
\item{df}{A data frame of replicated simulations which must include a column
titled "Estimate" with the effect estimate from the fitted model.}

\item{true_rr}{The true relative risk used to simulate the data.}
}
\value{
A data frame with a single value: the percent bias of the mean of the estimated
   coefficients over \code{n_reps} simulations.
}
\description{
This function returns the relative bias of the mean of the estimated coefficients.
}
\details{
This function estimates the percent bias in the estimated log relative risk
   (\eqn{b}) as:
\deqn{100 * \frac{\beta - \hat{\beta}}{\beta}}{100 ((\beta - b) / \beta)}
where \eqn{\hat{\beta}}{b} is the mean of the estimated log relative risk values from all
simulations and \eqn{\beta} is the true log relative risk used to simulate the data.
}
\examples{
sims <- create_sims(n_reps = 10, n = 600, central = 100,
                    sd = 10, exposure_type = "continuous",
                    exposure_trend = "cos1",
                    exposure_amp = 0.6,
                    average_outcome = 20,
                    outcome_trend = "no trend",
                    rr = 1.01)
fits <- fit_mods(data = sims, custom_model = spline_mod,
                 custom_model_args = list(df_year = 1))
beta_bias(fits, true_rr = 1.02)

}
