% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/customizable_functions.R
\name{fit_mods}
\alias{fit_mods}
\title{Fit a model to simulated datasets}
\usage{
fit_mods(data, custom_model = NULL, custom_model_args = list())
}
\arguments{
\item{data}{A list of simulated data sets. Each simulated dataset must include a
column called \code{x} with daily exposure values and a column called \code{outcome} with
daily outcome values. Typically, this will be the outcome from \code{\link{create_sims}}.}

\item{custom_model}{The object name of an R function that defines the code that will be used
to fit the model. This object name should not be in quotations. See Details for more.}

\item{custom_model_args}{A list of arguments and their values for a custom
model. These arguments are passed through to the function specified with \code{custom_model}.}
}
\value{
A data frame in which each row gives the results from the model-fitting function run
  on one of the simulated datasets input to the function as the \code{data} object. The returned
  data frame has one row per simulated dataset and the following columns:
  \itemize{
    \item{\code{Estimate}: The estimated \eqn{\beta} (log relative risk) as estimated by
      the model specified with \code{custom_model}.}
    \item{\code{Std.Error}: The standard error for the estimated \eqn{\beta}.}
    \item{\code{t.value}: The test statistic for a test of the null hypothesis \eqn{\beta = 0}.}
    \item{\code{p.value}: The p-value for a test of the null hypothesis \eqn{\beta = 0}.}
    \item{\code{lower_ci}: The lower value in the 95\% confidence interval estimated for
      \eqn{\beta}.}
    \item{\code{upper_ci}: The upper value in the 95\% confidence interval estimated for
      \eqn{\beta}.}
  }
}
\description{
Fits a specified model to each of the simulated datasets and returns a dataframe
summarizing results from fitting the model to each dataset, including the estimated
effect and the estimated standard error for that estimated effect. The model is specified
through a user-created R function, which must take specific input and return
output in a specific format. For more details, see the parameter definitions,
the Details section, and the vignette for the \code{eesim} package.
}
\details{
The function specified by the \code{custom_model} argument should be
   a user-created function that inputs a data frame with columns named "x" for
   exposure values and "outcome" for outcome values. The function must output a data
   frame with columns called \code{Estimate}, \code{Std. Error}, \code{t value},
   \code{Pr(>|t|)}, \code{2.5\%}, and \code{97.5\%}. Note that these columns are the output
   from \code{summary} and \code{confint} for models fit using a \code{glm} call. You may
   use the function \code{format_out} from eesim within your function to produce output
   with these columns if this model is fit using \code{glm} or something similar.
   For more details and examples, see the vignette for \code{eesim}.
}
\examples{
# Create a set of simulated datasets and then fit the model defined in `spline_mod` to
# all datasets, using the argument `df_year = 7` in the call to `spline_mod`. The `spline_mod`
# function is included in the `eesim` package and can be investigating by calling the function
# name without parentheses (i.e., `spline_mod`).
sims <- create_sims(n_reps = 10, n = 5 * 365, central = 100, sd = 10,
            exposure_type = "continuous", exposure_trend = "cos1",
            exposure_amp = .6, average_outcome = 22,
            outcome_trend = "no trend", outcome_amp = .6, rr = 1.01)
fit_mods(data = sims, custom_model = spline_mod, custom_model_args = list(df_year = 7))

}
