% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_sample.R
\name{make.sample}
\alias{make.sample}
\title{Generate fake election results for simulation studies}
\usage{
make.sample(
  M,
  N,
  strata = 1,
  per.winner = NULL,
  worst.e.max = NULL,
  R = NULL,
  tot.votes = 1e+05
)
}
\arguments{
\item{M}{The margin desired between the winner and loser (as a percent).}

\item{N}{Number of precincts desired.}

\item{strata}{Number of strata desired.}

\item{per.winner}{The percent of votes the winner should receive.}

\item{worst.e.max}{The worst e.max possible for any precinct.}

\item{R}{The "dispersion" a measure of how unequal in size precincts should
be.  R needs to be greater than 0.  NULL indicates equal size.  For R
between 0 and 1, the precincts are distributed 'linearly', i.e., the size of
precinct i is proportional to i.  At 2, the smallest precint will be near 0
and the largest twice the average votes per precinct.  After 2, the
precincts are distributed in a more curved fashion so that the smaller
precincts do not go negative.}

\item{tot.votes}{The total votes desired.}
}
\value{
A elec.data object meeting the desired specifications.
}
\description{
These methods are for SIMULATION STUDIES.  These functions will build a
sample, i.e. simulated, record of votes given certain parameters.
}
\examples{

Z = make.sample(0.08, 150, per.winner=0.4)
Z

Z2 = make.sample(0.08, 150, per.winner=0.4, R=2.2)
Z2

## Note how they have different precinct sizes.

summary(Z$V$tot.votes)
summary(Z2$V$tot.votes)



}
\references{
See http://www.stat.berkeley.edu/~stark/Vote/index.htm for
relevant information.
}
\seealso{
\code{\link{elec.data}} \code{\link{make.truth}}
\code{\link{do.audit}}
}
\author{
Luke W. Miratrix
}
