% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/basic.R
\name{expr_sub}
\alias{expr_sub}
\alias{expr_sub<-}
\title{Get or set a subexpression}
\usage{
expr_sub(expr, idx, env = parent.frame())

expr_sub(expr, idx, env = parent.frame()) <- value
}
\arguments{
\item{expr}{The expression to select from. Can also be a list of
expressions, in which case the first element of \code{index} selects the
expression from the list. Can also be a formula.}

\item{idx}{A valid index: \code{NULL} or an integer vector.}

\item{env}{Environment for any injections in \code{expr} (see
\link[=elixir-expression]{expression}).}

\item{value}{Replacement; an expression.}
}
\value{
The element of the expression selected by \code{idx}.
}
\description{
These functions allow you to extract and/or modify a subexpression within an
expression.
}
\details{
The \code{elixir} functions \code{\link[=expr_match]{expr_match()}} and \code{\link[=expr_locate]{expr_locate()}} find matching
"subexpressions" within expressions and return indices that allow accessing
these subexpressions. For example, the expression \code{1 + 2 + 3} contains all
the following subexpressions:\tabular{lcl}{
   \strong{index} \tab \strong{subexpression} \tab \strong{accessed with R code} \cr
   \code{NULL} \tab \code{1+2+3} \tab \code{expr} \cr
   \code{1} \tab \code{+} \tab \code{expr[[1]]} \cr
   \code{2} \tab \code{1+2} \tab \code{expr[[2]]} \cr
   \code{3} \tab \code{3} \tab \code{expr[[3]]} \cr
   \code{c(2,1)} \tab \code{+} \tab \code{expr[[2]][[1]]} or \code{expr[[c(2, 1)]]} \cr
   \code{c(2,2)} \tab \code{1} \tab \code{expr[[2]][[2]]} or \code{expr[[c(2, 2)]]} \cr
   \code{c(2,3)} \tab \code{2} \tab \code{expr[[2]][[3]]} or \code{expr[[c(2, 3)]]} \cr
}


Any index returned by \code{\link[=expr_match]{expr_match()}} or \code{\link[=expr_locate]{expr_locate()}} will either be
\code{NULL} (meaning the whole expression / expression list) or an integer vector
(e.g. \code{1} or \code{c(2,3)} in the table above).

Suppose you have an index, \code{idx}. If \code{idx} is an integer vector, you can
just use \code{expr[[idx]]} to access the subexpression. But in the case where
\code{idx} is \code{NULL}, R will complain that you are trying to select less than one
element. The sole purpose of \code{\link[=expr_sub]{expr_sub()}} is to get around that issue and
allow you to pass either \code{NULL} or an integer vector as the index you want
for an expression or list of expressions.
}
\examples{
expr = quote(y == a * x + b)
expr_sub(expr, NULL)
expr_sub(expr, 3)
expr_sub(expr, c(3, 3))

expr_sub(expr, c(3, 3)) <- quote(q)
print(expr)
}
\seealso{
\code{\link[=expr_match]{expr_match()}}, \code{\link[=expr_locate]{expr_locate()}} which return indices to
subexpressions.
}
