% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SkewOptimal.R
\name{SkewOptimal}
\alias{SkewOptimal}
\title{Tests for elliptical symmetry by Babic et al.}
\usage{
SkewOptimal(X, location = NA, f = "t", param = NA)
}
\arguments{
\item{X}{A numeric matrix.}

\item{location}{A vector of location parameters.}

\item{f}{A string that specifies the type of the radial density upon which the test is based. Currently supported options are \code{"t"}, \code{"logistic"} and \code{"powerExp"}.
The default is set to \code{"t"}.}

\item{param}{A parameter that is used when \code{f = "t"} and \code{f = "powerExp"}.
The default value of \code{param} represents the degrees of freedom of the multivariate t distribution and it is set to 4.}
}
\value{
An object of class \code{"htest"} containing the following components:
\item{\code{statistic}}{The value of the test statistic.}
\item{\code{pvalue}}{The p-value of the test.}
\item{\code{alternative}}{A character string describing the alternative hypothesis.}
\item{\code{method}}{A character string indicating what type of test was performed.}
}
\description{
Tests for elliptical symmetry: specified and unspecified location.
}
\details{
\code{X} and \code{location} are the only input arguments for the specified location test.
The default value for \code{location} is set to \code{NA} which implies that the unspecified location test will be performed
unless the user specifies location.

For the unspecified location test, besides the data matrix \code{X}, the input arguments are \code{f} and \code{param}.
The \code{f} argument is a string that specifies the type of the radial density upon which the test is based.
Currently supported options are: \code{"t"} for the radial density of the multivariate t distribution,
\code{"logistic"} for the multivariate logistic and \code{"powerExp"} for the radial density of the multivariate power-exponential distribution.
Note that the default is set to \code{"t"}.
The role of the \code{param} argument is as follows.
If \code{f = "t"} then \code{param} denotes the degrees of freedom of the multivariate t distribution.
Given that the default radial density is \code{"t"}, it follows that the default value of \code{param}
represents the degrees of freedom of the multivariate t distribution and it is set to 4.
Note also that the degrees of freedom have to be greater than 2.
If \code{f = "powerExp"} then \code{param} denotes the kurtosis parameter. In that case the value of \code{param}
has to be different from 1, because for the multivariate power exponential distribution, a kurtosis parameter equal to 1 corresponds
to the multivariate Gaussian distribution (the Gaussian \code{f} is excluded due to a singular Fisher information matrix).
The default value is set to 0.5.
}
\section{Background}{

Tests for elliptical symmetry both for specified and unspecified location. These tests are based on
Le Cam’s theory of statistical experiments and they are optimal against generalized skew-elliptical alternatives,
but they remain quite powerful under a much broader class of non-elliptical distributions.
They have a simple asymptotic chi-squared distribution under the null hypothesis of ellipticity,
they are affine-invariant, computationally fast, have a simple and intuitive form, only require finite moments of order 2.
}

\examples{

## sepal width and length of the versicolor subset of the Iris data
X = datasets::iris[51:100,1:2]


## location unspecified test based on the radial density of the multivariate t distribution
SkewOptimal(X)

## location unspecified test based on the radial density of the logistic distribution
SkewOptimal(X, f="logistic")

## location unspecified test based the radial density of the power exponential distribution
SkewOptimal(X, f="powerExp")

}
\references{
Babic, S., Gelbgras, L., Hallin, M., & Ley, C. (2021). Optimal tests for elliptical symmetry: specified and unspecified location. Bernoulli (in press).
}
