% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/provider-openai-tools.R
\name{openai_tool_web_search}
\alias{openai_tool_web_search}
\title{OpenAI web search tool}
\usage{
openai_tool_web_search(
  allowed_domains = NULL,
  user_location = NULL,
  external_web_access = TRUE
)
}
\arguments{
\item{allowed_domains}{Character vector. Restrict searches to specific domains
(e.g., \code{c("nytimes.com", "bbc.com")}). Maximum 20 domains. URLs will be
automatically cleaned (http/https prefixes removed).}

\item{user_location}{List with optional elements: \code{country} (2-letter ISO code),
\code{city}, \code{region}, and \code{timezone} (IANA timezone) to localize search results.}

\item{external_web_access}{Logical. Whether to allow live internet access
(\code{TRUE}, default) or use only cached/indexed results (\code{FALSE}).}
}
\description{
Enables OpenAI models to search the web for up-to-date information. The search
behavior varies by model: non-reasoning models perform simple searches, while
reasoning models can perform agentic, iterative searches.

Learn more at \url{https://platform.openai.com/docs/guides/tools-web-search}
}
\examples{
\dontrun{
chat <- chat_openai()
chat$register_tool(openai_tool_web_search())
chat$chat("Very briefly summarise the top 3 news stories of the day")
chat$chat("Of those stories, which one do you think was the most interesting?")
}
}
\seealso{
Other built-in tools: 
\code{\link{claude_tool_web_fetch}()},
\code{\link{claude_tool_web_search}()},
\code{\link{google_tool_web_fetch}()},
\code{\link{google_tool_web_search}()}
}
\concept{built-in tools}
