% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cache_utils.R
\name{clear_dataset_cache}
\alias{clear_dataset_cache}
\title{Clear cache for a specific dataset}
\usage{
clear_dataset_cache(
  dataset = c("ami", "fpl"),
  vintage = c("2018", "2022"),
  verbose = TRUE
)
}
\arguments{
\item{dataset}{Character, "ami" or "fpl"}

\item{vintage}{Character, "2018" or "2022"}

\item{verbose}{Logical, print progress messages}
}
\value{
Invisibly returns number of items cleared
}
\description{
Removes cached CSV files and database entries for a specific dataset/vintage.
Useful when you know a specific dataset is corrupted.
}
\examples{
\donttest{
# Clear corrupted AMI 2018 cache
clear_dataset_cache("ami", "2018")

# Clear FPL 2022 cache
clear_dataset_cache("fpl", "2022", verbose = TRUE)
}
}
