% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{orange_county_sample}
\alias{orange_county_sample}
\title{Orange County NC Energy Burden Sample Data}
\format{
A named list with 4 data frames:
\describe{
\item{fpl_2018}{Federal Poverty Line cohort data for 2018 (135 rows)}
\item{fpl_2022}{Federal Poverty Line cohort data for 2022 (206 rows)}
\item{ami_2018}{Area Median Income cohort data for 2018 (259 rows)}
\item{ami_2022}{Area Median Income cohort data for 2022 (149 rows)}
}

Each data frame contains:
\describe{
\item{geoid}{11-digit census tract identifier (character)}
\item{income_bracket}{Income bracket category (character)}
\item{households}{Number of households in this cohort (numeric)}
\item{total_income}{Total household income in dollars (numeric)}
\item{total_electricity_spend}{Total electricity spending in dollars (numeric)}
\item{total_gas_spend}{Total gas spending in dollars (numeric)}
\item{total_other_spend}{Total other fuel spending in dollars (numeric)}
}
}
\source{
U.S. Department of Energy Low-Income Energy Affordability Data (LEAD) Tool
\itemize{
\item 2018 vintage: \url{https://data.openei.org/submissions/573}
\item 2022 vintage: \url{https://data.openei.org/submissions/6219}
}
}
\usage{
orange_county_sample
}
\description{
A sample dataset containing energy burden data for Orange County, North Carolina
(FIPS code 37135). This dataset includes both Federal Poverty Line (FPL) and
Area Median Income (AMI) cohort data for 2018 and 2022 vintages.
}
\details{
This sample data is provided for quick demos, testing, and vignettes without
requiring a large download. For full state or national analysis, use
\code{\link{load_cohort_data}()} to download complete datasets from OpenEI.

\strong{Orange County NC} (Chapel Hill, Carrboro, Hillsborough):
\itemize{
\item 2018: 27 census tracts
\item 2022: 42 census tracts (tract boundaries changed)
}

\strong{Income Brackets}:
\itemize{
\item FPL: 0-100\%, 100-150\%, 150-200\%, 200-400\%, 400\%+
\item AMI: very_low, low_mod, mid_high (aggregated from 6 AMI categories)
}
}
\examples{
# Load sample data
data(orange_county_sample)

# View structure
names(orange_county_sample)

# Quick analysis of 2022 FPL data
library(dplyr)
orange_county_sample$fpl_2022 \%>\%
  group_by(income_bracket) \%>\%
  summarise(
    households = sum(households),
    avg_energy_burden = sum(total_electricity_spend + total_gas_spend + total_other_spend) /
                        sum(total_income)
  )

}
\seealso{
\itemize{
\item \code{\link{load_cohort_data}} - Load full datasets for any state
\item \code{\link{compare_energy_burden}} - Compare energy burden across vintages
\item \code{\link{calculate_weighted_metrics}} - Calculate weighted metrics with grouping
}
}
\keyword{datasets}
