% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/options.R
\name{hl_adjust}
\alias{hl_adjust}
\title{Set options for printing on the emphatic matrix or data.frame}
\usage{
hl_adjust(.data, na, full_colour, text_mode, text_contrast)
}
\arguments{
\item{.data}{emphatic matrix or data.frame}

\item{na}{Character string to display for NA values. Default 'NA'}

\item{full_colour}{Use 24bit ANSI escape codes?  default: FALSE - use 8bit colour.
Note: RStudio only supports 8 bit ANSI output (24bit ANSI is
rendered invisibly in Rstudio).  For 24bit colour output, try R in the terminal
e.g. 'iTerm' on OSX.}

\item{text_mode}{How to handle text if no text colour has been
explicitly specified by the user.
\describe{
\item{contrast}{(default) automatically select a contrasting colour for enhanced readability.}
\item{asis}{render text in the default text
     colour for the output device, unless the user has already specified
     a text colour at this location}
\item{remove}{remove all text without a user-defined colour}
}}

\item{text_contrast}{When \code{text_mode='contrast'} this numeric value in
range [0, 1] adjusts the visibility. Default: 1 (high contrast)}
}
\value{
emphatic object with updated options
}
\description{
Set options for printing on the emphatic matrix or data.frame
}
\examples{
mtcars |>
  hl('red') |>
  hl_adjust(text_contrast = 0.3)
}
