% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hl-grep.R
\name{hl_grep}
\alias{hl_grep}
\title{Colour highlighting a regular expression search}
\usage{
hl_grep(
  x,
  pattern,
  coerce = "default",
  opts = hl_opts(),
  fill = NULL,
  text = NULL,
  ...,
  perl = TRUE
)
}
\arguments{
\item{x}{character string}

\item{pattern}{regular expression string. Note: don't get too fancy here}

\item{coerce}{How should non-character arguments be coerced to character strings?
\describe{
  \item{default}{ - the given object \code{x} must already be a character string}
  \item{character}{ - performs the matching after first calling
          \code{as.character(x)}}
  \item{print}{ - performs the matching against the default
           \code{print(x)} output}
  \item{deparse}{ - performs the matching after first calling
          \code{deparse1(x)}}
  \item{str}{ - performs the matching on the output of calling
          \code{str(x)}}
}}

\item{opts}{create options list}

\item{fill}{solid colour for background.  If \code{NULL} (the default),
then the default colour will be selected}

\item{text}{text colour. If \code{NULL} (the default), then a colour
will be seleted which contrasts with the \code{fill} colour.}

\item{...}{extra args passed to \code{gsub}}

\item{perl}{logical. use perl style regex. default: TRUE}
}
\value{
An emphatic object suitable to output to console (for example)
}
\description{
Highlight text within an R object which matches a given regex. This
only works in a terminal which supports ANSI colour codes.

There are slightly different versions of the highlighting function depending
upon which text version of the object you'd like to match against:
}
\examples{
hl_grep(mode, 'switch')
}
