% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/energyGOF.R
\name{poisson_dist}
\alias{poisson_dist}
\title{Create a Poisson distribution object for energy testing}
\usage{
poisson_dist(lambda = NULL)
}
\arguments{
\item{lambda}{NULL, or if specified, same as the lambda in \code{\link[=rpois]{rpois()}}, but
must be length 1.}
}
\value{
S3 data object containing the following fields.
\itemize{
\item \code{name}: String
\item \code{composite_p}: Composite predicate. TRUE if test is composite.
\item \code{par}: Distribution parameters, list of the formals.
\item \code{sampler_par}: Distribution parameters used for the calculation of energy
statistic. These may be different than \code{par}.
\item \code{par_domain}: Function used to ensure \code{par} and \code{sampler_par} are valid for
this distribution
\item \code{support}: Function to check that data \code{x} can be tested against \code{y}
\item \code{sampler}: Function used for rng by \code{\link[boot:boot]{boot::boot()}}
\item \code{EYY}: Function to compute \eqn{E|Y-Y'|} (or \eqn{E|Y-Y'|^{pow}}, for the
generalized test.)
\item \code{EXYhat}: Function to compute \eqn{\frac{1}{n} \sum_i E|x_i - Y|} (or
\eqn{\frac{1}{n} \sum_i E|x_i - Y|^{pow}}), where Y is distributed according
to \code{y} and x is the data under test (which is passed in \code{egof.test} or \code{egofd}).
\item \code{xform}: Function that may be used to transform x. Only available in certain
distribution objects.
\item \code{statistic}: Function that returns a list of maximum likelihood estimates.
Only available in certain distribution objects.
\item \code{notes}: Distribution specific messages. Only used in certain distribution
objects.
}

\emph{Note}: Some distributions do not have notes, xform, and statistic fields.
This is because either a composite test is not implemented, or because a
data transformation is not needed.
}
\description{
Create an S3 object that sets all the required data needed by
energyGOFdist to execute the energy goodness-of-fit test against a Poisson
distribution. If lambda is NULL, a composite test is performed.
}
\examples{
d <- poisson_dist(1)

egofd(rpois(10, 1), d, 0)

}
\author{
John T. Haman
}
