% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deprecated.R
\name{cbmd}
\alias{cbmd}
\title{Combine two data with similar retention time while different mass range}
\usage{
cbmd(data1, data2, mzstep = 0.1, rtstep = 0.01)
}
\arguments{
\item{data1}{data file path of lower mass range}

\item{data2}{data file path of higher mass range}

\item{mzstep}{the m/z step for generating matrix data from raw mass spectral data}

\item{rtstep}{the alignment accuracy of retention time, e.g. 0.01 means the retention times of combined data should be the same at the accuracy 0.01s. Higher rtstep would return less scans for combined data}
}
\value{
matrix with the row as scantime in second and column as m/z
}
\description{
Combine two data with similar retention time while different mass range
}
\examples{
\dontrun{
# mz100_200 and mz201_300 were the path to the raw data
matrix <- getmd(mz100_200,mz201_300)
}
}
