% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate_tabulates.R
\name{calculate_tabulates}
\alias{calculate_tabulates}
\title{Tabulado con ponderacion}
\usage{
calculate_tabulates(
  base,
  x,
  y = NULL,
  weights = NULL,
  affix_sign = FALSE,
  digits = 1,
  add.totals = "none",
  add.percentage = "none"
)
}
\arguments{
\item{base}{Dataframe}

\item{x}{string con el nombre de la variable a tabular}

\item{y}{otro string (opcional) con el nombre de una segunda variable, para una tabla de doble entrada. Tiene que ser de igual largo que x}

\item{weights}{string con el nombre de la variable con los pesos de pesos, tiene que ser de igual largo que x}

\item{affix_sign}{si es TRUE agrega el signo \% al final}

\item{digits}{numero de digitos significativos}

\item{add.totals}{toma los valores c('none','row','col','both'), para agregar totales por fila, columna o ambos}

\item{add.percentage}{toma los valores c('none','row','col'), para agregar porcentajes por fila y columna}
}
\value{
Devuelve un tabulado uni o bivariado con ponderacion, totales parciales y porcentajes.
}
\description{
Funcion para crear tabulados uni o bivariados con ponderacion, totales parciales y porcentajes.
}
\examples{


### Tabla simple ###

calculate_tabulates(
  base = toybase_individual_2016_04,
  x = "REGION", y = "CH04",
  weights = "PONDERA"
)

### Totales por fila ###

calculate_tabulates(
  base = toybase_individual_2016_04,
  x = "REGION", y = "CH04",
  weights = "PONDERA", add.totals = "row"
)

### Totales por columna ###

calculate_tabulates(
  base = toybase_individual_2016_04,
  x = "REGION", y = "CH04",
  weights = "PONDERA", add.totals = "col"
)

### Porcentajes por fila ###

calculate_tabulates(
  base = toybase_individual_2016_04,
  x = "REGION", y = "CH04",
  weights = "PONDERA", add.percentage = "row"
)

}
