% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/epichains.R
\name{.new_epichains}
\alias{.new_epichains}
\title{Construct an \verb{<epichains>} object}
\usage{
.new_epichains(
  sim_df,
  n_chains,
  statistic,
  offspring_dist,
  stat_threshold,
  track_pop
)
}
\arguments{
\item{sim_df}{a \verb{<data.frame>} containing at least columns for
"infectee_id", "infector_id", and "generation". Also has optional columns
for "time", and "chain_id".}

\item{n_chains}{Number of chains to simulate.}

\item{statistic}{The chain statistic to track as the
stopping criteria for each chain being simulated when \code{stat_threshold} is not
\code{Inf}; A \verb{<string>}. It can be one of:
\itemize{
\item "size": the total number of cases produced by a chain before it goes
extinct.
\item "length": the total number of generations reached by a chain before
it goes extinct.
}}

\item{offspring_dist}{Offspring distribution: a \verb{<function>} like the ones
provided by R to generate random numbers from given distributions (e.g.,
\code{\link{rpois}} for Poisson). More specifically, the function needs to
accept at least one argument, \code{n}, which is the number of random
numbers to generate. It can accept further arguments, which will be passed
on to the random number generating functions. Examples that can be provided
here are \code{rpois} for Poisson distributed offspring, \code{rnbinom} for negative
binomial offspring, or custom functions.}

\item{stat_threshold}{A stopping criterion for individual chain simulations;
a positive number coercible to integer. When any chain's cumulative statistic
reaches or surpasses \code{stat_threshold}, that chain ends. Defaults to \code{Inf}.
For example, if \code{statistic = "size"} and \code{stat_threshold = 10}, then any
chain that produces 10 or more cases will stop. Note that setting
\code{stat_threshold} does not guarantee that all chains will stop at the same
value.}

\item{track_pop}{Was the susceptible population tracked? Logical.}
}
\description{
\code{new_epichains()} constructs an \verb{<epichains>} object from a
supplied \verb{<data.frame>} and extra attributes passed as individual arguments.
It is meant to be lazy and performant, by creating the object without
checking the arguments for correctness. It is not safe to call
\code{new_epichains()} on its own as is called within \code{epichains()}
after the arguments have been checked. To create an \verb{<epichains>}
object, use \code{epichains()}.
}
\author{
James M. Azam
}
\keyword{internal}
