% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/confounders_evalue.R
\name{confounders_evalue}
\alias{confounders_evalue}
\title{Compute E-value to assess bias due to unmeasured confounder.}
\usage{
confounders_evalue(
  est,
  lower_ci = NULL,
  upper_ci = NULL,
  sd = NA,
  type = c("RR", "ORc", "HRc", "diff_RR", "diff_OR"),
  true_est = 1
)
}
\arguments{
\item{est}{Point estimate for the effect measure. For difference in continuous outcomes,
it is the standardized effect size (i.e. mean of the outcome divided by its standard
deviation).}

\item{lower_ci}{Lower limit of the confidence interval for the association (relative
risk, odds ratio, hazard ratio, incidence rate ratio, risk difference).}

\item{upper_ci}{Upper limit of the confidence interval for the association (relative
risk, odds ratio, hazard ratio, incidence rate ratio, risk difference).}

\item{sd}{For difference in continuous outcomes, the standard error of the outcome
divided by its standard deviation.}

\item{type}{Choice of effect measure (relative risk, and odds ratio or hazard ratio
for rare outcomes i.e. < 15\% at end of follow-up -- RR; odds ratio for common
outcome -- ORc; hazard ratio for common outcome i.e. > 15\% at end of follow-up -- HRc;
difference in continuous outcomes, RR approximation -- diff_RR; difference in
continuous outcomes, OR approximation -- diff_OR).}

\item{true_est}{True estimate to assess E-value for. Default to 1 on risk scale
to assess against null value. Set to a different value to assess for non-null
hypotheses.}
}
\value{
A matrix with the observed point estimate and closest confidence interval to
the null hypothesis, expressed as a relative risk, and their corresponding E-value.
}
\description{
Help to quantify the evidence strength for causality in presence of unmeasured
confounding. The E-value is the minimum strength of association that an unmeasured
confounder would need to have with both the exposure and the outcome, conditional
on the measured covariates, to fully explain away a specific exposure-outcome
association.
}
\examples{
# The data for this example come from:
# Victoria C.G., Smith P.G., Vaughan J.P., Nobre L.C., Lombardi C., Teixeira A.M.
# et al.
# Evidence for protection by breast-feeding against infant deaths from infectious
# diseases in Brazil.
# Lancet 1987;2:319-22.
confounders_evalue(est = 3.9, type = "RR")

# The data for this example come from:
# Oddy W.H, Smith G.J., Jacony P.
# A possible strategy for developing a model to account for attrition bias in a
# longitudinal cohort to investigate associations between exclusive breastfeeding and
# overweight and obesity at 20 years.
# Annals of Nutrition and Metabolism 2014;65:234-235.
confounders_evalue(est = 1.47, lower_ci = 1.12, upper_ci = 1.93, type = "ORc")

# The data for this example come from:
# Reinisch J., Sanders S., Mortensen E., Rubin D.B.
# In-utero exposure to phenobarbital and intelligence deficits in adult men.
# Journal of the American Medical Association 1995;274:1518-1525
confounders_evalue(est = -0.42, sd = 0.14, type = "diff_RR")
}
\references{
VanderWeele T.J and Ding P. Sensitivity analysis in observational research:
Introducing the E-value. Annals of Internal Medicine 2017;167:268-274.
}
\seealso{
Other confounding: 
\code{\link{confounders}()},
\code{\link{confounders_array}()},
\code{\link{confounders_ext}()},
\code{\link{confounders_limit}()},
\code{\link{probsens_irr_conf}()}
}
\concept{confounding}
