% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filesystem.R
\name{setup_filesystem}
\alias{setup_filesystem}
\title{Setup the report filesystem}
\usage{
setup_filesystem(folders, clear.reports = FALSE)
}
\arguments{
\item{folders}{List. Contains paths to report folders with elements:
\itemize{
\item \code{internal}: Folder for internal reports
\item \code{public}: Folder for public reports
\item \code{settings}: Folder for settings files
}}

\item{clear.reports}{Logical. Whether to clear old reports from the internal
and public folders. Defaults to FALSE.}
}
\value{
The input folders list, unchanged.
}
\description{
\code{setup_filesystem} creates the necessary folder structure and optionally clears
old reports. This is a convenience function that combines \code{create_filesystem}
and \code{clear_old_reports}.
}
\examples{
# Create folders in a temporary directory
folders <- list(
  internal = file.path(tempdir(), "internal"),
  public = file.path(tempdir(), "public"),
  settings = file.path(tempdir(), "settings")
)
setup_filesystem(folders)
unlink(unlist(folders, use.names = FALSE), recursive = TRUE)
}
\seealso{
\code{\link[=create_filesystem]{create_filesystem()}}, \code{\link[=clear_old_reports]{clear_old_reports()}} which this function wraps.
}
