% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EQ_functions.R
\name{eqvs_drop}
\alias{eqvs_drop}
\title{eqvs_drop}
\usage{
eqvs_drop(country = NULL, version = "5L", saveOption = 1, savePath = NULL)
}
\arguments{
\item{country}{Optional string. If NULL, a list of current user-defined value sets will be provided for selection. If set, and matching an existing user-defined value set, a prompt will be given as to whether the value set should be deleted.}

\item{version}{Version of the EQ-5D instrument. Can take values 5L (default) or 3L.}

\item{saveOption}{Integer indicating how the cache data should be saved. 1: Do not save (default), 2: Save in package folder, 3: Save in another path.}

\item{savePath}{A path where the cache data should be saved when `saveOption` is 3. Please use `eqvs_load` to load it in your next session.}
}
\value{
True/False, indicating success or error.
}
\description{
Drop user-defined EQ-5D value set to reverse crosswalk options.
}
\examples{
\donttest{
  # make nonsense value set
  new_df <- data.frame(state = make_all_EQ_indexes(), TEST = runif(3125))
  # Add as value set for Fantasia
  eqvs_add(
   new_df,
   version = "5L",
   country = 'Fantasia',
   countryCode = "MyCountry",
   VSCode = "FAN",
   saveOption = 1
  )
  # Test the new value set
  eq5d5l(55555,country = "FAN")
  # Drop value set for Fantasia
  eqvs_drop(country = 'FAN', saveOption = 1)
}
}
