% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transform.R
\name{yr_transform}
\alias{yr_transform}
\title{Convert years from one era to another}
\usage{
yr_transform(x, era = yr_era(x), precision = NA)
}
\arguments{
\item{x}{\code{yr} object. A vector of years with an era, see \code{\link[=yr]{yr()}}.}

\item{era}{\code{era} object describing the target era, see \code{\link[=era]{era()}}.}

\item{precision}{Desired precision of the transformation, i.e. the
transformed values are rounded to the nearest \code{precision}. If \code{NA}
(the default), no rounding is performed and the exact transformed value is
returned.}
}
\value{
A \code{yr} object in the era specified by \code{era}.
}
\description{
Transform a vector of years from one era to another.
}
\details{
Transformation between eras uses the \code{scale}, \code{epoch}, \code{direction} and \code{unit}
parameters of the era definition. \code{NA} values for any of these parameters in
the source or destination era will cause an error. This is most often
encountered when either are measured in 'radiocarbon years', which cannot be
related to a calendar time scale without
\href{https://en.wikipedia.org/wiki/Radiocarbon_calibration}{calibration} or
un-calibration.

The transformation function is exact and treats years as a real number
scale. This means that transformations between eras with different year
units (e.g. Gregorian to Julian) and/or epochs not aligned to 1 January
in the Gregorian calendar (e.g. Common Era to Islamic calendars) will likely
return non-integer values. The \code{precision} argument provides a
convenient way to round the result if you do not need this level of
precision. It is also useful for working around the ambiguous definition of
'present' in various geological time-scales.
}
\examples{
x <- yr(10010:10001, "cal BP")
yr_transform(x, era("BCE"))

yr_transform(x, era("ka"), precision = 1)
}
\seealso{
Other years with era functions: 
\code{\link{yr}()},
\code{\link{yr_era}()}
}
\concept{years with era functions}
