% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gofN.R
\name{gofN}
\alias{gofN}
\alias{[.gofN}
\alias{augment.gofN}
\alias{summary.gofN}
\title{Linear model diagnostics for multinetwork linear models}
\usage{
gofN(
  object,
  GOF = NULL,
  subset = TRUE,
  control = control.gofN.ergm(),
  save_stats = FALSE,
  ...
)

\method{[}{gofN}(x, i, j, ..., drop = FALSE)

\method{augment}{gofN}(x, ...)

\method{summary}{gofN}(object, by = NULL, ...)
}
\arguments{
\item{object}{an \code{\link[ergm:ergm]{ergm}} object.}

\item{GOF}{a one-sided \code{\link[ergm:ergm]{ergm}} formula specifying network
statistics whose goodness of fit to test, or \code{\link{NULL}}; if \code{NULL},
uses the original model.}

\item{subset}{argument for the \code{\link[=N-ergmTerm]{N}} term.}

\item{control}{See \code{\link[=control.gofN.ergm]{control.gofN.ergm()}}.}

\item{save_stats}{If \code{TRUE}, save the simulated network statistics;
defaults to \code{FALSE} to save memory and disk space.}

\item{\dots}{additional arguments to functions (\code{\link[ergm:simulate.ergm]{simulate.ergm()}}
and \code{\link[ergm:summary.ergm_model]{summary.ergm_model()}}) for the constructor.}

\item{x}{a \code{gofN} object.}

\item{i}{for the indexing operator, index of statistics to be kept in the subset.}

\item{j}{for the indexing operator, index of networks to be kept in the subset.}

\item{drop}{whether the indexing operator should drop attributes and return simply a list.}

\item{by}{a numeric or character vector, or a formula whose RHS gives an expression in terms of network attributes, used as a grouping variable for summarizing the values.}
}
\value{
An object of class \code{gofN}: a named list containing a list
for every statistic in the specified \code{GOF} formula with the
following elements vectors of length equal to the number of
subnetworks:

\item{observed}{For completely observed networks, their value of
the statistic. For partially observed networks, the expected value
of their imputations under the model.}

\item{fitted}{Expected value of the statistic under the model.}

\item{var}{Variance of the statistic under the model.}

\item{var.obs}{Conditional variance under imputation statistic.}

\item{pearson}{The Pearson residual computed from the above.}

\item{stats,stats.obs}{If \code{save_stats} control parameter is \code{TRUE}, the simulated statistics.}

In addition, the following \code{\link[statnet.common:attr]{attr}}-style attributes are included:

\item{nw}{The observed multinetwork object.}

\item{subset}{A logical vector giving the subset of networks that were used.}

\item{control}{Control parameters passed.}
}
\description{
\code{\link[=gofN]{gofN()}} performs a simulation to obtain Pearson residuals for the
multivariate linear model for ERGM parameters, which can then be
used for a variety of diagnostics and diagnostic plots developed by
\insertCite{KrCo22t;textual}{ergm.multi}.
}
\section{Methods (by generic)}{
\itemize{
\item \code{[}: Extract a subset of statistics for which goodness-of-fit had been computed.

\item \code{augment(gofN)}: a method for constructing a \code{\link[tibble:tibble]{tibble}} of network attributes augmented with goodness of fit information. Columns include:\describe{
\item{network attributes}{the attributes of each of the networks}

\item{\code{.stat_name}}{name of the simulated statistic}

\item{\code{.stat_id}}{index of the simulated statistic in the \code{gofN} object}

\item{\code{.network_id}}{index of the network in the networks for which \code{gofN} was run (excluding those not in the subset)}

\item{\code{.fitted}}{predicted value for the statistic}

\item{\code{.observed}}{either the observed (for completely observed networks) or the predicted conditional on observed (for partially observed networks) value of the statistic}

\item{\code{.pearson}}{the standardised Pearson residual}

\item{\code{.var}, \code{.var.obs}}{estimated unconditional and average conditional variance of the statistic}

\item{\code{.weight}}{inverse of the variance of the residual}
}

\item \code{summary(gofN)}: A simple summary function.

}}
\examples{
data(samplk)
monks <- Networks(samplk1, samplk2, samplk3,samplk1, samplk2, samplk3,samplk1, samplk2, samplk3)
fit <- ergm(monks~N(~edges+nodematch("group")))
fit.gof <- gofN(fit) # GOF = original model
summary(fit.gof)
plot(fit.gof)
fit.gof <- gofN(fit, GOF=~triangles)
summary(fit.gof)
plot(fit.gof)

\donttest{
samplk1[1,]<-NA
samplk2[,2]<-NA
monks <- Networks(samplk1, samplk2, samplk3,samplk1, samplk2, samplk3,samplk1, samplk2, samplk3)
fit <- ergm(monks~N(~edges+nodematch("group")))
fit.gof <- gofN(fit) # GOF = original model
summary(fit.gof)
plot(fit.gof)
fit.gof <- gofN(fit, GOF=~triangles)
summary(fit.gof)
plot(fit.gof)
plot(fit.gof, against=~log(.fitted)) # Plot against transformed fitted values.
}

### If 'ggplot2' and 'ggrepel' are installed, illustrate the autoplot() method.
if(require("ggplot2") && requireNamespace("ggrepel")){
  autoplot(fit.gof)
}

# Default is good enough in this case, but sometimes, we might want to set it higher. E.g.,
\dontrun{
fit.gof <- gofN(fit, GOF=~edges, control=control.gofN.ergm(nsim=400))
}


### If 'generics' is installed, illustrate the augment() method.
if(require("generics")){
  augment(fit.gof)
}

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link[=plot.gofN]{plot.gofN()}} and \code{\link[=autoplot.gofN]{autoplot.gofN()}} for plotting \code{gofN}
objects to make residual plots; \code{\link[ergm:gof]{ergm::gof()}} for single-network
goodness-of-fit simulations in \CRANpkg{ergm}
}
