% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Load.R
\name{load.data}
\alias{load.data}
\title{Import your ERP data files.}
\usage{
load.data(path, condition, num.subs, epoch.st, epoch.end, bsln.cor = "n",
  header = FALSE)
}
\arguments{
\item{path}{The folder path containing your ERP files}

\item{condition}{In quotes, a string indicating which trial
type to be imported (i.e., the condition indicated in the file name)}

\item{num.subs}{The number of files (subjects) to import for a given condition}

\item{epoch.st}{The earliest time point sampled in the ERP files, including
the basline (e.g., -200)}

\item{epoch.end}{The final time point sampled in the ERP files (typically \eqn{
final time point - 1})}

\item{bsln.cor}{If "y", applies baseline correction to the imported data.  Baseline
correction is achieved by subtracting the mean voltage prior to 0 ms on a channel-
by-channel basis.}

\item{header}{Only accepts values of TRUE or FALSE. Used to specify whether or not there
is an existing header row in the ERP files.  If there is no header, \code{load.data}
will supply one (see details below).}
}
\value{
A single, concatenated data frame of all electrode data for all
  subjects organized into columns, with three added columns:

\enumerate{
  \item "Subject" containing repeating subject names
  \item "Stimulus" containing repeating condition names (e.g., Neutral)
  \item "Time" containing a repeating list of timepoints sampled
}
}
\description{
\code{load.data} imports your individual ERP data files. File extensions must be .txt and
  file names must be in the format: YourFile_Condition.txt (e.g., SS34_Positive.txt). Raw data files to be
  imported should be organized as follows:
\itemize{
  \item each electrode must be a separate column
  \item voltages at each time point should be listed under the appropriate electrode
    column as rows
 \item no other data should be present in the raw data file (e.g., subject, condition,
   time, etc.)
}
}
\details{
See also \code{\link{easy.load}} for a more user-friendly way to
  generate the appropriate code.

\itemize{
  \item Name each individual file following the format mentioned above (e.g., SS34_Positive.txt).
  \code{load.data} will ignore all text preceding the "_", and treat all text following the "_"
  as the \code{condition}, (e.g., Positive).  Use only one "_" in the file name (i.e., to separate
  your own naming convention from the \code{condition}); using multiple "_" characters will lead to
  faulty importing of data.  The erp.easy convention for subjects is a capital "S" followed by the
  number corresponding to the order in which the file was loaded (e.g., S1, S2, etc.). Subjects will
  be loaded into the "Subject" column of the returned data frame.

  \item If no header is present in the ERP files, one will be supplied, using the standard R
  convention of a capital "V" followed by increasing integers (e.g., V1, V2, V3). Use these
  automatically assigned column name values to refer to the electrodes (unless a header is provided
  in the raw data file).

  \item Enter the starting time of the baseline, if present in your individual files, in
  \code{epoch.st} (e.g., -200).

  \item Once the desired data frames have been loaded, they can be
  \href{http://www.statmethods.net/input/exportingdata.html}{exported} as a number of
  different file types.

  \item The sample rate will be calculated for you, based on the starting (\code{epoch.st})
  and ending (\code{epoch.end}) time points of the recording epoch and the number of time
  points in a given condition (the number of rows in your file for each condition).
}
}
\note{
While importing data must be done using a separate function call for each condition,
  it can be convenient to use R's native \code{rbind.data.frame()} command to bind
  several loaded conditions (variables) into a single data frame consisting of multiple
  conditions. All erp.easy functions will act on all conditions included in the data frame
  passed to the function. For example, if you'd like to see all conditions plotted, simply
  use \code{rbind.data.frame()} to make a single data frame to pass to an erp.easy plotting
  function, and you will see all added conditions plotted simultaneously in the same figure
  (as opposed to making separate data frames for each condition, then passing each data
  frame separately to a function).
}
\examples{
\dontrun{
# Importing data for a condition named "Neutral" (file names: "Sub1_Neutral.txt",
"Sub2_Neutral.txt", etc.)
neutral <- load.data(path = "/Users/Username/Folder/", condition = "Neutral",
num.subs = 20, epoch.st = -200, epoch.end = 899, header = FALSE)

# Adding imported data named "positive" to the imported "neutral" data
combo <- rbind.data.frame(neutral, positive)
}
}
\author{
Travis Moore
}
