% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Mosaic.R
\name{mosaic}
\alias{mosaic}
\title{Create average waveform plots for each subject in a single, multiplot window}
\usage{
mosaic(data, electrodes, cols = 5, rows = 5)
}
\arguments{
\item{data}{A data frame in the format returned from \code{\link{load.data}}}

\item{electrodes}{A single value or concatenation of several values (to be averaged)
indicating which electrodes to include in generating the plot. At this time, if the
raw data files imported using \code{\link{load.data}}) do not have a header, you
must include a capital "V" in front of the number and enclose each electrode in quotes.
(For example, electrodes = "V78", or electrodes = c("V78", "V76").)}

\item{cols}{An integer defining the number of desired columns of plots. The default is 5.}

\item{rows}{An integer defining the number of desired rows of plots. The default is 5.}
}
\value{
A single window containing multiple plots (1 per subject)
}
\description{
\code{mosaic} generates multiple plots in a single window. Plots are average waveforms
  for each subject. Each plot shows all conditions present in the data frame.
}
\details{
The default values for columns and rows (i.e., 5 and 5) and higher are best suited to
  the graphical parameters specified in the code. At this time, graphical parameters (e.g.,
  tick marks and labels) do not scale with the number of rows and colums. As this feature is
  not intended to produce manuscript-ready plots, the option to explore your data with any
  number of rows and columns is available, but fewer rows and columns will yield crowded plots.

  Single electrodes can be passed to the package functions, or several electrodes can
  be provided (i.e., when using dense arrays) and those electrodes will be averaged
  together as a single electrode.
}
\examples{
# Inspect average ERP waveforms for each subject
mosaic(ERPdata, electrodes = "V78", cols = 5, rows = 5)

}
\author{
Travis Moore
}
