% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/esDesign.R
\name{AED1_SSR.CP}
\alias{AED1_SSR.CP}
\title{Calculate the conditional power of the Adaptive Enrichment Design with
  (Strategy 1) Sample Size Re-estimation Procedure}
\usage{
AED1_SSR.CP(c, Z1, N1, N2)
}
\arguments{
\item{c}{The critical value used at the final analysis}

\item{Z1}{The test statistic obtained at the interim analysis}

\item{N1}{The sample size used at the first stage}

\item{N2}{The sample size used at the second stage}
}
\value{
A list contains
\itemize{
  \item Critical.Value The critical value used at the final analysis
  \item Conditional.Power The value of conditional power given the observed data
}
}
\description{
The \code{AED1_SSR.CP()} is used to calculate the conditional
   power of the Adaptive Enrichment Design (Strategy 1) with sample size
   re-estimation procedure
}
\examples{
c <- 2.258
Z1 <- 1.975
N1 <- 248
N2 <- 200
AED1_SSR.CP(c = 2.258, Z1 = 1.974, N1 = 248, N2 = 200)
}
\references{
\itemize{
  \item Lin, R., Yang, Z., Yuan, Y. and Yin, G., 2021. Sample size re-estimation
   in adaptive enrichment design. Contemporary Clinical Trials, 100, p.106216.
   <doi: 10.1016/j.cct.2020.106216>
}
}
