% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convert_esaps.R
\name{convert_esaps}
\alias{convert_esaps}
\title{Converts data in table form to tidy_data}
\usage{
convert_esaps(
  path = NULL,
  dataset = NULL,
  file.name = NULL,
  nSheets = 1,
  election.name,
  unit.name,
  M.name = NULL,
  votes_nac.name = NULL,
  seats = FALSE,
  allSheet = FALSE
)
}
\arguments{
\item{path}{Character vector containing one or more path names.}

\item{dataset}{Electoral results by party. It can be a \code{data.frame} or a \code{list}.}

\item{file.name}{Name of the data file with extension.}

\item{nSheets}{Number of countries (number of sheets).'
'Country' is a generic unit of analysis (province, department, etc.)}

\item{election.name}{Name of the variable that contains elections.}

\item{unit.name}{Name of the variable that contains the unit.
'unit' is a generic unit of analysis (province, department, etc.)}

\item{M.name}{Name of the variable that contains the district magnitude
(M+1). It is for the calculation of endogenous and exogenous
electoral volatility (Torcal and Lago, 2015).}

\item{votes_nac.name}{la la la}

\item{seats}{By default it is \code{FALSE}. If it is \code{TRUE}, it indicates that, in addition
to electoral data per party, there is allocation data per seat. In this case,
one column must be loaded for each party with the electoral result and another
with the number of seats it obtained. The structure must be:
party_1, party_2, ..., party_n, seats_party_1, seats_party_2, ..., seats_party_n.}

\item{allSheet}{By default it is \code{FALSE}. Load all the sheets that are in the
files selected in \code{file.name}. This argument takes precedence over \code{nSheets}.}
}
\value{
data.frame
}
\description{
Convert data in table format to tidy_data to use in the indicators of
    the tidy_data.
}
\examples{
votes <- list(data.frame(country = rep("ARG", 3),
                         year = c(1995, 2000, 2005),
                         party_A = c(40,10,20),
                         party_B = c(35,20,40),
                         party_C = c(25,70,40)),
              data.frame(country = rep("URY", 4),
                         year = c(1995, 2000, 2005, 2010),
                         party_A = c(30,30,20,20),
                         party_B = c(30,50,40, 30),
                         party_C = c(30,10,30, 25),
                         party_D = c(10,10,10,25)),
              data.frame(country = rep("BRA", 2),
                         year = c(1993, 1998),
                         party_A = c(30, 55),
                         party_B = c(70, 45)))

votes <- convert_esaps(dataset = votes, unit.name = "country", election.name = "year")


votes2 <- data.frame(year = c(2000, 2005),
                     country = "URY",
                     votes_party1 = c(20, 30),
                     votes_party2 = c(30, 35),
                     votes_party3 = c(40, 25),
                     votes_party4 = c(10, 10),
                     seats_party1 = c(25, 35),
                     seats_party2 = c(20, 30),
                     seats_party3 = c(40, 30),
                     seats_party4 = c(15, 5))

votes <- convert_esaps(dataset = votes2, unit.name = "country", election.name = "year",
                       seats = TRUE)


\dontrun{
v1 <- convert_esaps(path = getwd(),
                   file.name = c("electionBRA.xlsx", "electionARG.xlsx"),
                   election.name = "elec",
                   unit.name = "district",
                   allSheet = TRUE)

v2 <-convert_esaps(path = getwd(),
                   file.name = c("ARG.ods", "URY.ods", "BRA.ods"),
                   nCountry = c(2, 3, 1),
                   election.name = "elec",
                   unit.name = "province")

v3 <- convert_esaps(path = here::here(),
                   file.name = list.files(pattern = "*.xlsx"),
                   election.name = "year",
                   unit.name = "country",
                   M.name = "magnitude",
                   seats = TRUE,
                   allSheet = TRUE)
}

}
\author{
Nicolas Schmidt \email{nschmidt@cienciassociales.edu.uy}
}
