% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/esItems.R
\name{esItems}
\alias{esItems}
\title{esItems}
\usage{
esItems(dfList, RELEVANTVN_ES = NULL)
}
\arguments{
\item{dfList}{a list. Each element of the list must be a data.frame. Each data.frame is a separate raw ESM dataset/an ESM questionnaire version. If there is just one ESM version the list therefore contains one data.frame.}

\item{RELEVANTVN_ES}{a list. This list is generated by function \code{\link{setES}} and it is extended once either by function \code{\link{genDateTime}} or by function \code{\link{splitDateTime}}.}
}
\value{
A list with all the item names per ESM questionnaire version. Columns specifying dates, times, or IMEI numbers - as specified in function \code{\link{setES}} - are not used in function \code{\link{esPlausible}}, which takes the result of \code{esItems} as 2nd argument.
}
\description{
esItems registers the ESM questionnaire items as opposed to variables containing information about the questionnaire, e.g. the time stamps of when it was started and finished.
}
\examples{
# o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o
# Prerequisites in order to execute esItems. Start ------------------
# Use example list delivered with the package
RELEVANTVN_ES <- RELEVANTVN_ESext
# keyLsNew is a list of datasets, also delivered with the package
rmInvLs <- rmInvalid(keyLsNew, RELEVANTVN_ES)
# Prerequisites in order to execute esItems. End --------------------
# -------------------------------------------------------
# Run function 11 of 29; see esmprep functions' hierarchy.
# -------------------------------------------------------
# Extract the item names of the raw ESM datasets. rmInvLs[["dfValid"]]
# is one of the results from function 'rmInvalid'
plausibItems <- esItems(dfList=rmInvLs[["dfValid"]], RELEVANTVN_ES)
# o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o
}
\seealso{
Exemplary code (fully executable) in the documentation of \code{\link{esmprep}} (function 11 of 29).
}
