% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/randomMultSelection.R
\name{randomMultSelection}
\alias{randomMultSelection}
\title{randomMultSelection}
\usage{
randomMultSelection(esDf)
}
\arguments{
\item{esDf}{a data.frame. A single ESM dataset. It must contain the 2 columns that hold the date-time object for when an ESM questionnaire was started and finished, respectively.}
}
\value{
The user receives a list containing 2 datasets:
\enumerate{
\item esRandSelIn, i.e. the ESM dataset with the lines of data, of which some had to be randomly selected
\item esRandSelOut, i.e. the lines of data that had to be randomly removed.
}
See \strong{Details} for more information.
}
\description{
randomMultSelection selects ESM questionnaires randomly as specified by the user.
}
\details{
If \code{randomMultSelection} has to be applied it should better be applied only once at the very end of the study. Otherwise the randomness of the selection no longer holds.
}
\examples{
# o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o
# Prerequisites in order to execute randomMultSelection. Start ------
# RELEVANTINFO_ES is delivered with the package
intoleranceDf <- data.frame(prompt = c(2, 3, 4, 1, 1),
expect = c(1, 1, 1, 2, 3))
# expectedDf is a raw ESM dataset, delivered with the package.
intolLs <- intolerable(expectedDf, intoleranceDf, RELEVANTINFO_ES)
# Prerequisites in order to execute randomMultSelection. End --------
# -------------------------------------------------------
# Run function 25 of 29; see esmprep functions' hierarchy.
# -------------------------------------------------------
# intolLs[["cleanedDf"]] is the result of function 'intolerable'.
randSelLs <- randomMultSelection(intolLs[["cleanedDf"]])
# o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o
}
\seealso{
Exemplary code (fully executable) in the documentation of \code{\link{esmprep}} (function 25 of 29).
}
