% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/levinsohn_petrin.R
\name{levinsohn_petrin}
\alias{levinsohn_petrin}
\title{Levinsohn-Petrin Estimation of Production Functions}
\usage{
levinsohn_petrin(
  data,
  formula = y ~ free | capital | proxy | controls,
  exit = NULL,
  gross = FALSE,
  id = "id",
  time = "year",
  bootstrap = TRUE,
  reps = 2,
  degree = c(3, 3),
  verify = TRUE,
  maxiter = 100,
  ...
)
}
\arguments{
\item{data}{A data.frame or tibble containing the variables of the model.}

\item{formula}{An object of the class \code{\link[stats]{formula}}.}

\item{exit}{An optional formula with the name of the variabe indicator of firm's last period. \emph{~exit}, for example.}

\item{gross}{If TRUE dependent variable is gross output.}

\item{id}{A character with the name of the indicator variable.}

\item{time}{A character with the name of the time variable.}

\item{bootstrap}{An optional logical. If TRUE calculate bootstrap standard errors.}

\item{reps}{The number of bootstrap replications.}

\item{degree}{A vector with the number of polynomial interactions in each stage of the routine.}

\item{verify}{Verify if inputs are sorted.}

\item{maxiter}{Parameter of \code{nls.lm} at second stage.}

\item{...}{Additional arguments.}
}
\description{
This function aims the estimation of production functions using \href{http://www.nber.org/papers/w7819}{Levinsohn-Petrin (2000)}.
}
\details{
Multipart formula must be specified in the following order: \code{y ~ free | capital | proxy | controls}. Additional controls are optional.
It is possible to use more than one variable, although the use of more than one capital may not be theoretically identified.
The function returns an object of the estprod or boot classes (if \code{bootstrap} is TRUE).
}
\examples{
data(estprod_data)
levinsohn_petrin(data = estprod_data, var1 ~ var2 | var3 | var4, 
exit = ~exit, id = "id", time = "year", bootstrap = TRUE)
}
