% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/etl_load.R
\name{smart_upload}
\alias{smart_upload}
\title{Upload a list of files to the DB}
\usage{
smart_upload(obj, src = NULL, tablenames = NULL, ...)
}
\arguments{
\item{obj}{An \link{etl} object}

\item{src}{a list of CSV files to upload. If \code{NULL}, will return all
CSVs in the load directory}

\item{tablenames}{a list the same length as \code{src} of tablenames in the
database corresponding to each of the files in \code{src}. If \code{NULL},
will default to the same name as \code{src}, without paths or file extensions.}

\item{...}{arguments passed to \code{\link[DBI:dbWriteTable]{DBI::dbWriteTable()}}}
}
\description{
Upload a list of files to the DB
}
\examples{
\dontrun{
if (require(RMariaDB)) {
  # must have pre-existing database "fec"
  # if not, try
  system("mysql -e 'CREATE DATABASE IF NOT EXISTS fec;'")
  db <- src_mysql_cnf(dbname = "mtcars")
}
}
}
