% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/authenticate.R
\name{etrd_auth_credentials}
\alias{etrd_auth_credentials}
\title{Auth Step 1: Set ETRADE Key and Secret Credentials}
\usage{
etrd_auth_credentials(etrade_key, etrade_secret, sandbox = FALSE)
}
\arguments{
\item{etrade_key}{Either a sandbox or production key provided by ETRADE after
completing the agreements on
\href{https://developer.etrade.com/getting-started}{ETRADE Developer}}

\item{etrade_secret}{Either a sandbox or production secret provided by ETRADE
after completing the agreements on
\href{https://developer.etrade.com/getting-started}{ETRADE Developer}}

\item{sandbox}{ETRADE offers a sandbox environment for validating API calls
and responses. If using the sandbox environment, this must be set to TRUE
in each function called throughout etrader. ETRADE states "Sandbox
responses use stored data that's intended to provide typical responses for
basic use cases. So the responses you receive will not contain current
data, and may not exactly match your requests in other ways." Essentially,
the responses will not match the requests entered but successful pull will
indicate whether the entry was valid or not.}
}
\value{
an oauth app stored into options by default
}
\description{
Step 1 of ETRADE authentication. Create an oauth app using the key and secret
that can be obtained after completing the agreements on
\href{https://developer.etrade.com/getting-started}{ETRADE Developer}.
}
\details{
Authentication into the ETRADE environment requires a three step process: set
ETRADE credentials, generate request tokens to create a login URL, and use
the verification code to create access tokens. The Key and Secret need to be
fed into this function to set the credentials into an oauth app that can be
fed into the next function: \code{\link{etrd_auth_login_url}}.
}
\examples{
\dontrun{

# Pass the key and secret from ETRADE
etrade_cred = etrd_auth_credentials(etrade_key = 'PRODUCTION_ALPHANUMERIC_OAUTH_KEY',
                                    etrade_secret = 'PRODUCTION_ALPHANUMERIC_OAUTH_SECRET')

}
}
\seealso{
\code{\link{etrd_auth_credentials}} to set the key and secret into
  an oauth app, \code{\link{etrd_auth_login_url}} to generate request tokens
  and create a login URL, \code{\link{etrd_auth_access_token}} to use the
  verification code to create access tokens,
  \code{\link{etrd_auth_manage_token}} to renew or revoke access tokens
}
