% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distances.R
\name{dist_comp}
\alias{dist_comp}
\title{Distances}
\usage{
dist_comp(x, lp = 2)
}
\arguments{
\item{x}{Object containing the original univariate observations. Currently available
types and the form they need to have to be correctly recognized are the
following:
\itemize{
\item Logical: logical vectors;
\item Numeric: numeric or integer vectors;
\item Nominal: factors;
\item Functions: objects of class \code{"fdata"};
\item Graphs: (lists of) objects of class \code{"igraph"};
\item Persistence diagrams: (lists of) objects with
\code{attributes(x)$names == "diagram"}.
}
See Details to find out which distance is used in each case.}

\item{lp}{Integer specifying which norm should be used to compute the
distances for functional data.}
}
\value{
Object of class \code{"dist"} containing the pairwise distances.
}
\description{
Compute pairwise distances starting from single objects containing the
original univariate observations.
}
\details{
The distances used in each case are the following:
\itemize{
\item Logical: Euclidean distance, implemented via \code{\link[stats:dist]{dist()}};
\item Numeric: Euclidean distance, implemented via \code{\link[stats:dist]{dist()}};
\item Nominal: Gower's distance, implemented via \code{\link[cluster:daisy]{daisy()}};
\item Functions: \eqn{L^{p}}{L^p}-norm, implemented via
\code{\link[fda.usc:metric.lp]{metric.lp()}} with default options;
\item Graphs: Edge Difference distance (Hammond et al., 2013), implemented via
\code{\link[NetworkDistance:nd.edd]{nd.edd()}};
\item Persistence diagrams: Wasserstein distance, implemented via
\code{\link[TDA:wasserstein]{wasserstein()}} with default options;
}
}
\examples{

# Number of observations
nobs <- 10

## Logical 
obj <- as.logical(rbinom(nobs, 1, 0.5))
d <- dist_comp(obj)

## Integer
obj <- rpois(nobs, 5)
d <- dist_comp(obj)

## Numeric
obj <- rnorm(nobs)
d <- dist_comp(obj)

## Factors
obj <- factor(letters[1:nobs])
d <- dist_comp(obj)

## Functional data
obj <- fda.usc::rproc2fdata(nobs, seq(0, 1, len = 100), sigma = 1)
d <- dist_comp(obj)

## Graphs
obj <- lapply(1:nobs, function(j) igraph::sample_gnp(100, 0.2))
d <- dist_comp(obj)

## Persistence diagrams
x <- lapply(rep(100, nobs), function(np) TDA::circleUnif(np))
obj <- lapply(x, TDA::ripsDiag, maxdimension = 1, maxscale = 3)
d <- dist_comp(obj)

}
\references{
D. K. Hammond, Y. Gur, and C. R. Johnson (2013). Graph diffusion distance: A
difference measure for weighted graphs based on the graph laplacian
exponential kernel. In \emph{2013 IEEE Global Conference on Signal and
Information Processing}, pages 419-422.
}
