% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extras.R
\name{describe}
\alias{describe}
\title{Describe a given Eurostat dataset on the basis of information from Metabase}
\usage{
describe(
  EurostatDatasetCode,
  import_labels = !wide,
  wide = FALSE,
  import_dim_labels = TRUE
)
}
\arguments{
\item{EurostatDatasetCode}{A string with Eurostat dataset code name, e.g. \code{"nama_10_gdp"} or \code{"bop_its6_det"}.
See e.g.: \url{https://ec.europa.eu/eurostat/databrowser/explore/all/all_themes} where, once you follow one of the "branches"
of the "tree" of datasets, the dataset codes are in tiny grey font in square brackets just under the full names of the datasets
(the names are in navy blue and preceded by a cube icon).}

\item{import_labels}{Boolean: should labels for the codes inside dimensions be imported. Default: if \code{wide} is
\code{FALSE} then \code{import_labels} is TRUE and vice versa.}

\item{wide}{Boolean: should each dimension be compressed to one row and all values within each dimension to a single,
comma-separated string. Default: \code{FALSE}.}

\item{import_dim_labels}{Boolean: should the dimensions (e.g. \code{geo}, \code{indic_is}, or \code{nace_r2}) be labelled with a descriptive
name (via \code{\link{importDimLabel}}). Default: \code{TRUE}.}
}
\value{
A \link[data.table]{data.table} with columns \code{Dim_name}, \code{Dim_name_label} (if \code{import_dim_labels}=\code{TRUE}),
either \code{Dim_val} (if \code{wide=FALSE}) or \code{Dim_values} (if \code{wide=TRUE}),
\code{Dim_val_label} (if \code{import_labels}=\code{TRUE}), and a column with a name = \code{EurostatDatasetCode} with all
its values = \code{TRUE}.
}
\description{
Describe a given Eurostat dataset on the basis of information from Metabase
}
\examples{
\dontrun{
describe('nama_10_gdp')
}
}
