% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-internal-apis.R
\name{.inheritParams}
\alias{.inheritParams}
\title{Api internal functions}
\arguments{
\item{competition_code}{One or more competition codes.\cr
Admitted values are \code{E} for Euroleague and \code{U} for Eurocup.}

\item{team_code}{One or more team codes as obtained from \code{\link[=getCompetitionTeams]{getCompetitionTeams()}}.\cr
Examples are \code{ASV}, \code{MAD}, ...}

\item{game_code}{One or more game codes as obtained from \code{\link[=getCompetitionGames]{getCompetitionGames()}}.}

\item{season_code}{One or more season codes as obtained from \code{\link[=getCompetitionHistory]{getCompetitionHistory()}}.\cr
Examples are \code{E2023} for Euroleague or \code{U2023} for Eurocup 2023.}

\item{round}{One or more round codes as obtained from \code{\link[=getCompetitionRounds]{getCompetitionRounds()}}.}

\item{phase_type}{One or more phase type codes as obtained from \code{\link[=getCompetitionPhases]{getCompetitionPhases()}}.\cr
Admitted values are \code{RS} for regular season, \code{PO} for playoffs and \code{FF} for final four.
Default is \code{All} for all.}

\item{subset}{One or more game subsets.\cr
Admitted values are \code{HomeGames}, \code{AwayGames}, \code{GamesWon}, \code{GamesLost},
\code{ResultsIn5Points} (for games resulted in +/-5 points) and \code{All}.
Default is \code{All}.}

\item{statistic_mode}{One or more aggregation modes of statistics.\cr
Admitted values are \code{perGame}, \code{perMinute} and \code{accumulated}.}
}
\description{
Primitive Api wrapper functions are not exported since they only allow for one
call at a time.
Instead, an equivalent functions is exposed allowing multiple
parameters, making it easier to retrieve data for users.

\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
}
\keyword{internal}
