% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get-competition-streaks.R
\name{getCompetitionStreaks}
\alias{getCompetitionStreaks}
\title{Get competition streaks standings}
\usage{
getCompetitionStreaks(season_code, round)
}
\arguments{
\item{season_code}{One or more season codes as obtained from \code{\link[=getCompetitionHistory]{getCompetitionHistory()}}.\cr
Examples are \code{E2023} for Euroleague or \code{U2023} for Eurocup 2023.}

\item{round}{One or more round codes as obtained from \code{\link[=getCompetitionRounds]{getCompetitionRounds()}}.}
}
\value{
Returns a summary tibble of streaks for chosen competitions and rounds

Reference webpage: \href{https://www.euroleaguebasketball.net/euroleague/standings/?season=2023-24&type=Streaks&phase=REGULAR\%20SEASON}{Streaks standings}
}
\description{
Get competition streaks standings
}
\examples{

\dontrun{

getCompetitionStreaks(season_code = c("E2023", "E2022"), round = 1)

}

}
\keyword{`r}
\keyword{competitionStandings}
\keyword{lifecycle::badge('experimental')`}
