% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get-player-misc.R
\name{getPlayerMisc}
\alias{getPlayerMisc}
\title{Get player miscellaneous statistics}
\usage{
getPlayerMisc(season_code)
}
\arguments{
\item{season_code}{One or more season codes as obtained from \code{\link[=getCompetitionHistory]{getCompetitionHistory()}}.\cr
Examples are \code{E2023} for Euroleague or \code{U2023} for Eurocup 2023.}
}
\value{
Returns a summary tibble of miscellaneous players statistics for chosen seasons.

Glossary of columns:\tabular{lll}{
   \strong{Column name} \tab \strong{Column extended name} \tab \strong{Column description} \cr
   DD2 \tab Double-doubles \tab Games with double-digit totals in two of: points, rebounds, assists, steals and blocks \cr
   TD3 \tab Triple-doubles \tab Games with double-digit totals in three of: points, rebounds, assists, steals and blocks \cr
}


Reference webpage: \href{https://www.euroleaguebasketball.net/euroleague/stats/expanded/?size=1000&viewType=miscellaneous&seasonCode=E2023&statisticMode=accumulated&seasonMode=Single&sortDirection=descending&statistic=gamesPlayed}{Stats}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
}
\examples{

\dontrun{

getPlayerMisc(season_code = "E2023")

}

}
