% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/threshold.R
\name{ebc_tidy_by_threshold}
\alias{ebc_tidy_by_threshold}
\title{Measures by threshold}
\usage{
ebc_tidy_by_threshold(
  detection_values,
  true,
  all,
  m = length(all),
  measures = c("TPR", "FPR", "FDR", "ACC", "F1"),
  direction = c("<", ">", "<=", ">=")
)
}
\arguments{
\item{detection_values}{Values corresponding to elements that are detected.
Must be named.}

\item{true}{Vector of element that are supposed to be detected.}

\item{all}{Vector of all elements.}

\item{m}{Total number of elements.}

\item{measures}{Desired measures of performance.}

\item{direction}{With \code{<} (default), detected elements are those
which are strictly less than the threshold. Could be change to \code{">"},
\code{<=} or \code{>=}.}
}
\value{
A dataframe with one column called threshold and other corresponding
to those specified in \code{measures}.
}
\description{
Computes measures according to a moving threshold.
}
\details{
See \code{\link{ebc_allmeasures}} for the available measures and
their descriptions.
}
\examples{
set.seed(42)
X1 <- rnorm(50)
X2 <- rnorm(50)
X3 <- rnorm(50)
predictors <- paste0("X", 1:3)
df_lm <- data.frame(X1 = X1, X2 = X2, X3 = X3,
                    X4 = X1 + X2 + X3 + rnorm(50, sd = 0.5),
                    X5 = X1 + 3 * X3 + rnorm(50, sd = 0.5),
                    X6 = X2 - 2 * X3 + rnorm(50, sd = 0.5),
                    X7 = X1 - X2 + rnorm(50, sd = 2),
                    Y  = X1 - X2 + 3 * X3 + rnorm(50))
model <- lm(Y ~ ., data = df_lm)
pvalues <- summary(model)$coefficients[-1, 4]
ebc_tidy_by_threshold(pvalues, predictors, m = 7)
}
