% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/itr_qoi.R
\name{compute_qoi_user}
\alias{compute_qoi_user}
\title{Compute Quantities of Interest (PAPE, PAPEp, PAPDp, AUPEC, GATE, GATEcv) with user defined functions}
\usage{
compute_qoi_user(user_itr, Tcv, Ycv, data, ngates, budget, ...)
}
\arguments{
\item{user_itr}{A user-defined function to create an ITR. The function should take the data as input and return an unit-level continuous score for treatment assignment. We assume those that have score less than 0 should not have treatment. The default is \code{NULL}, which means the ITR will be estimated from the \code{estimate_itr}.}

\item{Tcv}{A vector of the unit-level binary treatment.}

\item{Ycv}{A vector of the unit-level continuous outcome.}

\item{data}{A data frame containing the variables of interest.}

\item{ngates}{The number of gates to be used in the GATE function.}

\item{budget}{The maximum percentage of population that can be treated under the budget constraint.}

\item{...}{Additional arguments to be passed to the user-defined function.}
}
\description{
Compute Quantities of Interest (PAPE, PAPEp, PAPDp, AUPEC, GATE, GATEcv) with user defined functions
}
