% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_rn.R
\name{calc_rn}
\alias{calc_rn}
\alias{calc_rn,missing,missing,missing,missing,missing-method}
\alias{calc_rn,Raster,Raster,Raster,Raster,ANY-method}
\alias{calc_rn,character,character,character,character,ANY-method}
\title{Calculate Net Radiation (Rn)}
\usage{
calc_rn(tmax, tmin, rs, elevation, albedo = 0.23, x = NULL)

\S4method{calc_rn}{missing,missing,missing,missing,missing}(x)

\S4method{calc_rn}{Raster,Raster,Raster,Raster,ANY}(tmax, tmin, rs, elevation, albedo = 0.23, x = NULL)

\S4method{calc_rn}{character,character,character,character,ANY}(tmax, tmin, rs, elevation, albedo = 0.23, x = NULL)
}
\arguments{
\item{tmax}{Raster* object or file path for maximum temperature (°C)}

\item{tmin}{Raster* object or file path for minimum temperature (°C)}

\item{rs}{Raster* object or file path for solar radiation (MJ m-2 day-1)}

\item{elevation}{Raster* object or file path for elevation (m)}

\item{albedo}{Numeric, Raster*, or file path for albedo (optional, default = 0.23)}

\item{x}{A `data.table` with columns: "lon", "lat", "date", "rs", "tmax", 
"tmin", "elevation", and optionally "albedo"}
}
\value{
RasterBrick or data.table of net radiation values (MJ m-2 day-1)
}
\description{
Computes net radiation (Rn) based on solar radiation, temperature, and elevation.
}
\details{
For raster inputs, provide individual raster objects or file paths for `tmax`, 
`tmin`, `rs`, `elevation`, and optionally `albedo`. For `data.table` input, 
provide a single `data.table` with columns: "lon", "lat", "date", "rs", "tmax", 
"tmin", "elevation", and optionally "albedo".
}
\examples{
\donttest{
# Example using Raster* input
if (requireNamespace("raster", quietly = TRUE)) {
  tmax_path <- file.path(tempdir(), "tmax.nc")
  tmin_path <- file.path(tempdir(), "tmin.nc")
  rs_path   <- file.path(tempdir(), "rs.nc")
  elev_path <- file.path(tempdir(), "elevation.nc")

  if (file.exists(tmax_path) && file.exists(tmin_path) &&
      file.exists(rs_path) && file.exists(elev_path)) {
    tmax <- raster::brick(tmax_path)
    tmin <- raster::brick(tmin_path)
    rs   <- raster::brick(rs_path)
    elev <- raster::brick(elev_path)

    rn <- calc_rn(tmax = tmax, tmin = tmin, rs = rs, elevation = elev)
  }
}

# Example using data.table input
if (requireNamespace("data.table", quietly = TRUE)) {
  dt <- data.table::data.table(
    lon = c(10.0, 10.5),
    lat = c(45.0, 45.5),
    date = as.Date(c("2001-06-01", "2001-06-01")),
    tmax = c(28.3, 27.6),
    tmin = c(14.1, 13.5),
    rs = c(22.5, 21.9),
    elevation = c(400, 420)
  )
  rn_dt <- calc_rn(x = dt)
}
}
}
