% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/detect_exeve.R
\name{detect_exeve}
\alias{detect_exeve}
\title{Detect Extreme Evaporation Events (ExEvE)}
\usage{
detect_exeve(x, EXTREMES_THRES = 0.95, LOW_THRES = 0.8)
}
\arguments{
\item{x}{A \code{data.table} containing columns: \code{lon}, \code{lat},
\code{date}, and \code{value}, representing daily evaporation values.}

\item{EXTREMES_THRES}{Numeric. Quantile threshold used to define
extreme evaporation events. Default is 0.95.}

\item{LOW_THRES}{Numeric. Lower quantile threshold. Default is 0.80.}
}
\value{
A \code{data.table} with original columns and added columns:
\itemize{
  \item \code{std_value} — standardized evaporation
  \item \code{pentad_std_q80}, \code{pentad_std_q95} — pentad thresholds
  \item \code{value_above_low_thres}, \code{extreme}, \code{evap_event} — flags
  \item \code{above_low_thres_id}, \code{extreme_id}, \code{event_id} — event group IDs
}
}
\description{
The function \code{detect_exeve} identifies extreme evaporation events based
on standardized evaporation and extreme thresholds.
}
\examples{
\donttest{
# Example using an RDS file (only run if file exists)
evap_path <- file.path(tempdir(), "czechia_evap_gleam.rds")
if (file.exists(evap_path)) {
  evap <- readRDS(evap_path)
  events <- detect_exeve(evap)
}
}
}
