% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LTRE_fns.R
\name{classicalLTRE_fixed}
\alias{classicalLTRE_fixed}
\title{Classical LTRE analysis: one-way fixed design}
\usage{
classicalLTRE_fixed(Aref, Atreatment)
}
\arguments{
\item{Aref}{The population projection matrix of the reference population.
Depending on the experimental or observational dataset, this may be the
control treatment, the first time period, the unharvested population, etc.}

\item{Atreatment}{The population projection matrix of a treatment population.}
}
\value{
A matrix of contributions to the difference in lambda. Lambda is the
asymptotic population growth rate, defined as the largest eigenvalue of the
population projection matrix.
}
\description{
Life Table Response Experiments (LTREs) are a method of comparative demographic
analysis. The purpose is to quantify how the difference or variance in vital
rates (stage-specific survival, growth, and fertility) among populations '
contributes to the difference or variance in the population growth rate,
"lambda." ' The equations and descriptions for the classical methods of LTRE
analysis ' can be found in Caswell's 2001 textbook.
}
\details{
Lambda is the asymptotic population growth rate, defined as the
largest eigenvalue of the population projection matrix. A fixed design LTRE
decomposes the difference in lambda due to differences at each position of
the matrices. For a fixed design LTRE, exactly 2 matrices must be provided,
ordered as \verb{[reference matrix, treatment matrix}]. The matrix of contributions
returned from a classical method fixed design LTRE will have the same shape
as the provided matrices.

In some cases, it may not be obvious how to identify the reference and the
treatment matrix. The sum of contributions will be approximately equal to the
observed difference in lambda between these two matrices, evaluated as
lambda(Atreatment) - lambda(Aref). In cases where it doesn't 'matter' which way
you, as a user, input these matrices, it is important to understand how to
interpret positive and negative contributions.

The equations and descriptions for the classical methods of LTRE analysis
can be found in Caswell's 2001 textbook.
}
\examples{
A1<- matrix(data=c(0,0.8,0, 0,0,0.7, 5,0,0.2), nrow=3, ncol=3)
A2<- matrix(data=c(0,0.9,0, 0,0,0.5, 4,0,0.3), nrow=3, ncol=3)
cont_diff<- classicalLTRE_fixed(A1, A2) # contributions to the difference in lambda
}
