% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{process_bootstrap_stats}
\alias{process_bootstrap_stats}
\title{Process Bootstrap Statistics}
\usage{
process_bootstrap_stats(
  bootstrap_stats = bootstrap_stats,
  density_args = density_args,
  lb = lb,
  ub = ub
)
}
\arguments{
\item{bootstrap_stats}{A numeric vector of bootstrap statistics.}

\item{density_args}{A list of additional arguments to be passed to the density function. Default is NULL.}

\item{lb}{A numeric value specifying the lower bound for the confidence interval.}

\item{ub}{A numeric value specifying the upper bound for the confidence interval.}
}
\value{
A list with two elements: dens (a density estimate of the bootstrap
sample statistics) and stats (a list of summary statistics including number of
resamples, mode, median, mean, standard deviation, lower confidence interval
(lCI), and upper confidence interval (uCI)).
}
\description{
This function takes in bootstrap statistics and additional arguments to compute
the density estimate of the bootstrap statistic, the number of resamples,
the mode, median, mean, standard deviation, and confidence interval. It returns
a list containing the density estimate and summary statistics.
}
\keyword{internal}
