library(eRm)
# list of 3 is returned (item combinations, fit rasch model and ppar)
data(ADL)
testthat::test_that("test_mloef: p-value 0.088, alpha: 0.05",{
  testthat::expect_equal(length(
    exhaustiveRasch::test_mloef(items=1:5, dset=ADL, na.rm=TRUE, modelType="RM",
                                 alpha=0.05, estimation_param = estimation_control(est="eRm"))),
               expected=3)})

# list of 3 is returned (item combinations, fit rasch model and ppar)
data(ADL)
testthat::test_that("test_mloef: p-value 0.088, alpha: 0.05; na.rm=FALSE",{
  testthat::expect_equal(length(
    exhaustiveRasch::test_mloef(items=1:5, dset=ADL,
                                na.rm=FALSE, modelType="RM",
                                alpha=0.05,
                                estimation_param=
                                  estimation_control(est="eRm"))),
    expected=3)})

# list of 3 is returned (item combinations, fit rasch model and ppar)
data(ADL)
firstrun <- exhaustiveRasch::test_mloef(
  items=1:5, dset=ADL,
  na.rm=FALSE, modelType="RM",
  alpha=0.05,
  estimation_param=
    estimation_control(est="eRm"))
testthat::test_that("test_mloef: p-value 0.088, alpha: 0.05;
                    with pre-fitted model in 'items' parameter",{
  testthat::expect_equal(length(
    exhaustiveRasch::test_mloef(items=firstrun, dset=ADL,
                                na.rm=FALSE, modelType="RM",
                                alpha=0.05,
                                estimation_param=
                                  estimation_control(est="eRm"))),
                         expected=3)})


# empty list is returned
data(ADL)
testthat::test_that("test_mloef: p-value 0.088, alpha: 0.1",{
  testthat::expect_equal(length(
    exhaustiveRasch::test_mloef(items=1:5, dset=ADL, na.rm=TRUE, modelType="RM",
                                estimation_param=
                                  estimation_control(est="eRm"))),
  expected=0)})

