% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expandFunctions.R
\name{polywrapper}
\alias{polywrapper}
\title{Generate special functions using orthonormal functions}
\usage{
polywrapper(basePoly = orthopolynom::chebyshev.t.polynomials, kMax = 0)
}
\arguments{
\item{basePoly}{A polynomial list from orthopoly}

\item{kMax}{Integer.  The maximum order of the function
generated.}
}
\value{
Function which is compatible with eOuter and eMatrixOuter
}
\description{
orthopolynom can be used to generate special functions,
but for expansion they should be modified.  As of this
writing, orthopolynom generates polynomials for
Chebyshev, Hermite, Legendre and many other functions,
their integrals and derivatives, and more.
}
\details{
The function polywrapper does 2 things:

\itemize{
  \item{Generate functions from polynomial coefficients.}
  \item{Uses x as the 1st argument, and the order as
  the second; this means the generated functions can be
  used in eOuter and eMatrixOuter.}
}

The functions so generated can be used as simple special functions,
as well as being useful in feature building.

Since the coefficients from orthopolynom are generated
         by recursion, an upper limit of the function order
         needs to be set when calling polywrapper.  This is the
         main limitation of polywrapper.  Fortunately, since
         the functions are compactly stored, kMax can be set
         quite high if desired.  Note that usually the kMax
         is known, and is relatively small.

         NB: The input x may need to be normalized.  orthopolynom
         has the function scaleX for just such a purpose.
}
\examples{
# Generate a Chebyshev function of the form
# chebyFUN(x,k), where x is the input and k is the order.
# In this case, k must be no more than 5 (since that
# is the value passed to kMax), although it is
# easy to set this to a higher order if desired.
chebyFUN <- polywrapper(basePoly=orthopolynom::chebyshev.t.polynomials,
  kMax=5)
# Now the function chebyFUN
# can be used as any other function:
x <- seq(-1,+1,0.01)
plot(x,chebyFUN(x,5),type="l")
eOuter(seq(-1,+1,0.01),0:3,chebyFUN)
}

