% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/survHE_funcs.R
\name{compile_stan}
\alias{compile_stan}
\title{Compile Specified Stan Models for Bayesian Survival Analysis}
\usage{
compile_stan(dist_stan = c("exp", "wei", "wph", "rps", "llo", "lno"))
}
\arguments{
\item{dist_stan}{A character vector specifying the distributions to compile. Options include:
\describe{
\item{\code{"exp"}}{Exponential distribution}
\item{\code{"wei"}}{Weibull distribution}
\item{\code{"wph"}}{Weibull Proportional Hazards}
\item{\code{"rps"}}{Restricted Piecewise Survival}
\item{\code{"llo"}}{Log-Logistic distribution}
\item{\code{"lno"}}{Log-Normal distribution}
}
Defaults to \code{c("exp", "wei", "wph", "rps", "llo", "lno")}.}
}
\value{
A named list of compiled Stan models corresponding to the specified distributions.
}
\description{
The \code{compile_stan} function pre-compiles specified Stan models used in the \code{expertsurv} package for Bayesian survival analysis. By compiling the models ahead of time, you can significantly reduce computation time during model fitting, as the models won't need to be compiled each time they're used.
}
\details{
Pre-compiling Stan models is recommended when working with Bayesian methods in survival analysis, as it avoids the overhead of compiling models during each function call. This is particularly beneficial when running multiple models or iterations.

The function internally calls \code{rstan::stan_model()} for each specified distribution, compiling the Stan code associated with that model.
}
\examples{
\donttest{
library(dplyr)
# Prepare the data
# Assume 'data' is your dataset containing 'time' and 'censored' variables
data2 <- data \%>\%
  rename(status = censored) \%>\%
  mutate(
    time2 = ifelse(time > 10, 10, time),
    status2 = ifelse(time > 10, 0, status)
  )

# Pre-compile Stan models (ideally after installing the package)
# This step can be time-consuming but only needs to be done once per session
compiled_models_saved <- compile_stan()

# Fit the survival models using Bayesian methods
example1 <- fit.models.expert(
  formula = Surv(time2, status2) ~ 1,
  data = data2,
  distr = c("wei", "gom"),  # Weibull and Gompertz distributions
  method = "bayes",
  compile_mods = compiled_models_saved)

# Examine the results
summary(example1)
plot(example1)

}
}
\seealso{
\link[=compile_stan]{compile_stan}
}
