% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{exp1}
\alias{exp1}
\title{Stability potency data of five batches}
\format{
A data frame with 53 observations and 3 variables:
\describe{
  \item{Batch}{Factor with levels \code{b2}, \code{b3}, \code{b4}, \code{b5},
               \code{b7} and \code{b8}}
  \item{Month}{Numeric representing the time points of testing from the
               start (0 months) to the end (24 months) of the study.}
  \item{Potency}{Numeric of the measured potency values in \%LC}
}
}
\source{
See reference: Example data sets shown in Tables IV, VI and VIII.
}
\usage{
data(exp1)
}
\description{
A data set containing the potency stability data (in \% of label claim (LC))
of five batches of a drug product obtained over a 24 months period. A total
of \eqn{n = 53} independent measurements are available (corresponding to
data shown in Tables IV, VI and VIII in LeBlond et al. (2011)). Data in
Table IV (batches \code{b2}, \code{b5} and \code{b7}) are compatible with a
common intercept / common slope (cics) model, data in Table VI (batches
\code{b3}, \code{b4} and \code{b5}) with a different intercept / common slope
(dics) model  and data in Table VIII (bathes \code{b4}, \code{b5} and
\code{b8}) with a different intercept / different slope (dids) model.
}
\examples{
str(exp1)
}
\references{
LeBlond, D., Griffith, D. and Aubuchon, K. Linear Regression 102: Stability
Shelf Life Estimation Using Analysis of Covariance. \emph{J Valid Technol}
(2011) \strong{17}(3): 47-68.
}
\keyword{datasets}
