% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/skewness.R
\name{skewness}
\alias{skewness}
\title{Skewness}
\usage{
skewness(vector = NULL, type = "adjusted")
}
\arguments{
\item{vector}{a numeric vector}

\item{type}{a character string indicating the type of skewness to
calculate. If \code{type = "adjusted"}, the adjusted Fisher-Pearson
standardized moment coefficient will be calculated. If
\code{type = "traditional"}, the traditional Fisher-Pearson
coefficient of skewness will be calculated. If \code{type = "pearson_2"},
the Pearson 2 skewness coefficient will be calculated. By default,
\code{type = "adjusted"}.}
}
\value{
a numeric value, i.e., skewness of the given vector
}
\description{
Calculate skewness using one of three formulas: (1) the traditional
Fisher-Pearson coefficient of skewness; (2) the adjusted
Fisher-Pearson standardized moment coefficient; (3) the Pearson 2
skewness coefficient. Formulas were taken from Doane & Seward (2011),
\doi{10.1080/10691898.2011.11889611}
}
\examples{
# calculate the adjusted Fisher-Pearson standardized moment coefficient
exploratory::skewness(c(1, 2, 3, 4, 5, 10))
# calculate the traditional Fisher-Pearson coefficient of skewness
exploratory::skewness(c(1, 2, 3, 4, 5, 10), type = "traditional")
# compare with skewness from 'moments' package
moments::skewness(c(1, 2, 3, 4, 5, 10))
# calculate the Pearson 2 skewness coefficient
exploratory::skewness(c(1, 2, 3, 4, 5, 10), type = "pearson_2")
}
